// メニュー関連－－－－－－－－－－－－－－－－－－－－－－－－－－－－－－－
// スマホ用メニュー　クラス追加
const menubtn = document.querySelector("#js-menubtn");
const nav = document.querySelector("#js-globalnav");

menubtn.addEventListener("click", function () {
 menubtn.classList.toggle("_active");
  nav.classList.toggle("_active");
});

// 子メニュー表示
const parentMenu = document.querySelectorAll("._has-child > a");
for (let i = 0; i < parentMenu.length; i++) {
 parentMenu[i].addEventListener("click", function(e){
  e.preventDefault();
  this.nextElementSibling.classList.toggle("active");
 })
}

// スクロールしたらメニューのスタイル変更
window.addEventListener("scroll", function () {
 nav.classList.toggle("scroll-nav", window.scrollY > 180);
});


// スクロール関連－－－－－－－－－－－－－－－－－－－－－－－－－－－－－－
// 1. すべてのhref="#"のaタグを取得
const smoothScrollTrigger = document.querySelectorAll('a[href^="#"]');
// 2. 1のaタグにそれぞれクリックイベントを設定
for (let i = 0; i < smoothScrollTrigger.length; i++) {
  smoothScrollTrigger[i].addEventListener("click", (e) => {
    // 3. ターゲットの位置を取得
    e.preventDefault();
    let href = smoothScrollTrigger[i].getAttribute("href"); // 各a要素のリンク先を取得
    let targetElement = document.getElementById(href.replace("#", "")); // リンク先の要素（コンテンツ）を取得

    const rect = targetElement?.getBoundingClientRect().top; // ブラウザからの高さを取得
    const offset = window.pageYOffset; // 現在のスクロール量を取得
    const gap = 70; // 固定ヘッダー分の高さ
    const target = rect + offset - gap; //最終的な位置を割り出す
    // 4. スムースにスクロール
    window.scrollTo({
      top: target,
      behavior: "smooth"
    });
  });
}


// ページUP
const PageUpBtn = document.getElementById('js-pageup');

window.addEventListener("scroll", function () {
 PageUpBtn?.classList.toggle("_active", window.scrollY > 700);
});

PageUpBtn?.addEventListener('click', () => {
 window.scrollTo({
  top: 0,
  behavior: 'smooth'
 });
});


// キャラクター紹介タブ－－－－－－－－－－－－－－－－－－－－－－－－－－－
// ボタン
const nameList = document.querySelectorAll(".charanamelist__item");
// コンテンツ
const charaContent = document.querySelectorAll(".charalist__item");

document.addEventListener("DOMContentLoaded", function () {
  for (let i = 0; i < nameList.length; i++) {
    nameList[i].addEventListener("click", charaSwitch);
  }
  function charaSwitch() {
    document.querySelectorAll(".active")[0]?.classList.remove("active");
    this?.classList.add("active");
    document.querySelectorAll(".show")[0].classList.remove("show");
    const aryList = Array.prototype.slice.call(nameList);
    const index = aryList.indexOf(this);
    charaContent[index].classList.add("show");
  }
});


// 文字装飾－－－－－－－－－－－－－－－ーー－－－－－－－－－－－－－－－
/**
 * 文字列を一文字ずつ<span>で囲む関数
 * @param {String} str
 * @return {String}
 */
const wrapCharSpan = function(str){
 return [...str].map(char => `<span>${char}</span>`).join('');
}

//対象の要素を取得する
const target = document.querySelector('.colors');
//要素の内容を関数の実行結果で置き換える
target.innerHTML = wrapCharSpan(target.textContent);