// スマホ用メニュー　クラス追加
const ham = document.querySelector("#js-hamburger");
const nav = document.querySelector("#js-globalnav");
const Main = document.querySelector("#js-main");

ham.addEventListener("click", function () {
  ham.classList.toggle("_active");
  nav.classList.toggle("_active");
  Main.classList.toggle("_darker");
});



// 子メニュー表示
const parentMenu = document.querySelectorAll(".globalnav ._has-child > a");
for (let i = 0; i < parentMenu.length; i++) {
 parentMenu[i].addEventListener("click", function(e){
  e.preventDefault();
  this.nextElementSibling.classList.toggle("active");
  this.parentElement.classList.toggle("active");
 })
}


// ページUP
const PageUpBtn = document.getElementById('js-pageup');

window.addEventListener("scroll", function () {
 const scroll = window.pageYOffset;
 if (scroll > 700) {
  PageUpBtn.style.opacity = 1;
 } else PageUpBtn.style.opacity = 0;
});

PageUpBtn?.addEventListener('click', () => {
 window.scrollTo({
  top: 0,
  behavior: 'smooth'
 });
});


// Comic登場人物
// タブ
const nameList = document.querySelectorAll('.charanamelist__item');
// タブコンテンツ
const charaContent = document.querySelectorAll('.charalist__item');
 
//DOMが読み込み終わったら
document.addEventListener('DOMContentLoaded', function(){
  // タブに対してクリックイベントを適用
  for(let i = 0; i < nameList.length; i++) {
    nameList[i].addEventListener('click', charaSwitch);
  }
  // タブをクリックすると実行する関数
  function charaSwitch(){
    // activeクラスを削除
    document.querySelectorAll('.active')[0]?.classList.remove('active');
    // クリックしたタブにactiveクラスを付与    
    this?.classList.add('active');
    // showクラスを削除
    document.querySelectorAll('.show')[0]?.classList.remove('show');
    // タブを配列風オブジェクトとして定義
    const aryList = Array.prototype.slice.call(nameList);
    // クリックしたタブの配列番号を取得     
    const index = aryList.indexOf(this);
    // クリックしたタブと同じ配列番号のタブコンテンツにshowクラスを付与    
    charaContent[index]?.classList.add('show');
  };
});

