// スマホ用メニュー　クラス追加
const ham = document.querySelector("#js-hamburger");
const nav = document.querySelector("#js-globalnav");
const Main = document.querySelector("#js-main");

ham.addEventListener("click", function () {
 ham.classList.toggle("_active");
 nav.classList.toggle("_active");
 Main.classList.toggle("_darker");
});

// 子メニュー表示
const parentMenu = document.querySelectorAll("._has-child > a");
for (let i = 0; i < parentMenu.length; i++) {
 parentMenu[i].addEventListener("click", function(e){
  e.preventDefault();
  this.nextElementSibling.classList.toggle("active");
  this.parentElement.classList.toggle("active");
 })
}


// COMIC用メニュー　クラス追加
const comicbtn = document.querySelector("#js-comicnav-btn");
const comicnav = document.querySelector("#js-comicnav");

comicbtn?.addEventListener("click", function () {
 comicbtn.classList.toggle("_active");
 comicnav.classList.toggle("_active");
});


// 小説ページ送りメニュー
const novelpageBtn = document.querySelector("#js-novelpage-btn");
const novelpageTurn = document.querySelector("#js-novelpage-turn");

novelpageBtn?.addEventListener("click", function () {
 novelpageBtn.classList.toggle("_active");
 novelpageTurn.classList.toggle("_active");
});

// 縦横変換ボタン　クラス追加
const yoko = document.querySelector("#js-yoko");
const tate = document.querySelector("#js-tate");
const novelPage = document.querySelector("#js-novelpage");

yoko?.addEventListener("click", function () {
 novelPage.classList.add("horizontal");
 if (novelPage.classList.contains("horizontal")) {
  novelPage.classList.remove("vertical");
 }
});

tate?.addEventListener("click", function () {
 novelPage.classList.add("vertical");
 if (novelPage.classList.contains("vertical")) {
  novelPage.classList.remove("horizontal");
 }
});

// ページUP
const PageUpBtn = document.getElementById('js-pageup');

Main.addEventListener("scroll", function () {
 const scrollPc = Main.scrollTop;
 if (scrollPc < 300) {
  PageUpBtn.style.opacity = 0;
 } else PageUpBtn.style.opacity = 1;
});

window.addEventListener("scroll", function () {
 const scroll = window.pageYOffset;
 if (scroll < 600) {
  PageUpBtn.style.opacity = 0;
 } else PageUpBtn.style.opacity = 1;
});

PageUpBtn?.addEventListener('click', () => {
 Main.scrollTo({
  top: 0,
  behavior: 'smooth'
 });
});

// タブ
const nameList = document.querySelectorAll('.charanamelist__item');
// タブコンテンツ
const charaContent = document.querySelectorAll('.charalist__item');
 
//DOMが読み込み終わったら
document.addEventListener('DOMContentLoaded', function(){
  // タブに対してクリックイベントを適用
  for(let i = 0; i < nameList.length; i++) {
    nameList[i].addEventListener('click', charaSwitch);
  }
  // タブをクリックすると実行する関数
  function charaSwitch(){
    // activeクラスを削除
    document.querySelectorAll('.active')[0]?.classList.remove('active');
    // クリックしたタブにactiveクラスを付与    
    this?.classList.add('active');
    // showクラスを削除
    document.querySelectorAll('.show')[0]?.classList.remove('show');
    // タブを配列風オブジェクトとして定義
    const aryList = Array.prototype.slice.call(nameList);
    // クリックしたタブの配列番号を取得     
    const index = aryList.indexOf(this);
    // クリックしたタブと同じ配列番号のタブコンテンツにshowクラスを付与    
    charaContent[index]?.classList.add('show');
  };
});